/* ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ******************************************************************************** */

/* ********************* LICENSE STRINGS **********************
#*     To unlock the full functionality of Phone Object,       *
#* please call a sales representative at 1-800-MELISSA ext. 3  *
#*         (1-800-635-4772 x3) for a license string.           *
#*  Phone Object will not function without a valid             *
#*      			  license string 			          	   *
#************************************************************* */


set pagesize 50000;
set long 20000;
set echo off;
set pages 999;
set serveroutput on;

truncate table log;
commit;

declare
  po pls_integer;
  bno varchar2(100);
  val varchar2(32767);
  ok integer;
  counter integer := 0;
  err_num NUMBER;
  err_msg VARCHAR2(100);

begin

  po := mdPhoneCreate();
  insert into log values('created mdPhone object');
  commit;

  ok := mdPhoneSetLicenseString(po, 'SET_LICENSE_HERE');
  insert into log values('set license: ok=' || ok);
  commit;

  bno := mdPhoneGetBuildNumber(po);
  insert into log values('build number= ' || bno);
  commit;

  ok := mdPhoneInitialize(po, 'SET_PATH_HERE');
  insert into log values('init datafiles: error=' || ok);
  commit;


  val := mdPhoneGetInitErrorString(po);
  insert into log values('init error string = ' || val);
  commit;

  val := mdPhoneGetDatabaseDate(po);
  insert into log values('database date = ' || val);
  commit;

  for rec in (select * from md_apne_table) loop
  BEGIN
    ok := mdPhoneLookup(po, NVL(rec.PHONE,' '), ' ');
    val := '(' || mdPhoneGetAreaCode(po) || ')' || mdPhoneGetPrefix(po) || '-' || mdPhoneGetSuffix(po) || ' ' || mdPhoneGetExtension(po) || ' ' || mdPhoneGetCity(po) || ' ' || mdPhoneGetState(po);
    DBMS_OUTPUT.PUT_LINE(val);
    DBMS_OUTPUT.PUT_LINE(counter);
    counter := counter + 1;
    EXCEPTION
       WHEN OTHERS THEN
	  err_num := SQLCODE;
	  err_msg := SUBSTR(SQLERRM, 1, 100);
	  insert into log values('ORA' || err_num || ': ' || err_msg);
	  insert into log values(val);
	  commit;
	  exit;
    END;
  end loop;

  if err_num != -28576
  then
    mdPhoneDestroy(po);
    insert into log values('destroyed mdName object');
    commit;
  end if;

end;
/
